#!/bin/bash
dataset_target='superglue-multirc'
source="record"
json_file="./attempt/configs/fewshot/fewshot_naked.json"
fewshot_num=1
model_name="t5-base"
# full or few-shot
eval_dataset_type='full'
target_prompt_embedding_path="/export/home/OpenPrompt/mixture_prompt/source_prompts/${source}_prompt.pt"

export CUDA_VISIBLE_DEVICES='1'
save_dir="./outputs/baselines/source_full/${model_name}/${dataset_target}_${source}_2"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --data_full \
  --fewshot_num $fewshot_num \
  --save_dir $save_dir \
  --eval_dataset_type $eval_dataset_type \
  --model_name $model_name\
  --fewshot_source \
  --target_prompt_embedding_path $target_prompt_embedding_path \
  > ${save_dir}/debug.log 2>&1 &