#!/bin/bash
dataset_target='mrpc'
json_file="./attempt/configs/baselines/finetuning.json"
fewshot_num=1
model_name="t5-3b"
# full or few-shot
eval_dataset_type='full'

#export CUDA_VISIBLE_DEVICES='0'
save_dir="./outputs/baselines/ft_fewshot_table/t5_3b/${dataset_target}"
mkdir -p $save_dir

NUM_GPUS_PER_WORKER=8 # number of gpus used on one node
NUM_NODES=2
MASTER_PORT=${1-1234}
export CUDA_VISIBLE_DEVICES='0,1,2,3,4,5,6,7'
deepseed_path="./attempt/configs/deepseed/ds_fp16.json"
#nohup python \
#nohup python -m torch.distributed.launch \
#  --nproc_per_node ${NUM_GPUS_PER_WORKER} \
deepspeed --num_gpus=8 \
  ./attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --save_dir $save_dir \
  --eval_dataset_type $eval_dataset_type \
  --model_name $model_name \
  --deepspeed $deepseed_path \
  > ${save_dir}/debug.log 2>&1 &