#!/bin/bash
dataset_target='wnli'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=20
attn_method='sub'
self_teach_num=1
sample_method='trainable'

export CUDA_VISIBLE_DEVICES='0'
save_dir="./outputs/self_training_sample/sample_loss_trainable_${dataset_target}"
self_train_source_dir="./outputs/self_training_sample/sample_uniform_${dataset_target}"
eval_file_path="/export/home/OpenPrompt/mixture_prompt/plots/train_loss_acc_teacher.pickle"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/sample_pseudo.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --self_train_source_dir $self_train_source_dir \
  --sample_method $sample_method \
  --eval_file_path $eval_file_path \
  > ${save_dir}/debug.log 2>&1 &