#!/bin/bash
dataset_target='stsb'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=20
attn_method='sub'
self_teach_num=1

export CUDA_VISIBLE_DEVICES='0'
save_dir="./outputs/self_training_sample/sample_uniform_${dataset_target}"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/sample_pseudo.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --self_train_source_dir $save_dir \
  > ${save_dir}/debug.log 2>&1 &

###
dataset_target='mrpc'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=20
attn_method='sub'
self_teach_num=1

export CUDA_VISIBLE_DEVICES='1'
save_dir="./outputs/self_training_sample/sample_uniform_${dataset_target}"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/sample_pseudo.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --self_train_source_dir $save_dir \
  > ${save_dir}/debug.log 2>&1 &

###
dataset_target='superglue-rte'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=20
attn_method='sub'
self_teach_num=1

export CUDA_VISIBLE_DEVICES='2'
save_dir="./outputs/self_training_sample/sample_uniform_${dataset_target}"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/sample_pseudo.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --self_train_source_dir $save_dir \
  > ${save_dir}/debug.log 2>&1 &

###
dataset_target='superglue-multirc'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=20
attn_method='sub'
self_teach_num=1

export CUDA_VISIBLE_DEVICES='3'
save_dir="./outputs/self_training_sample/sample_uniform_${dataset_target}"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/sample_pseudo.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --self_train_source_dir $save_dir \
  > ${save_dir}/debug.log 2>&1 &

###
#dataset_target='superglue-multirc'
#json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
#fewshot_num=20
#attn_method='sub'
#self_teach_num=1
#
#export CUDA_VISIBLE_DEVICES='4'
#save_dir="./outputs/self_training_sample/sample_uniform_${dataset_target}"
#mkdir -p $save_dir
#
#nohup python \
#  attempt/seq2seq/sample_pseudo.py \
#  --json_file $json_file \
#  --dataset_target $dataset_target \
#  --fewshot \
#  --fewshot_num $fewshot_num \
#  --attn_method $attn_method \
#  --save_dir $save_dir \
#  --self_teach_num $self_teach_num \
#  --self_train \
#  --self_train_source_dir $save_dir \
#  > ${save_dir}/debug.log 2>&1 &
#
####
#dataset_target='superglue-rte'
#json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
#fewshot_num=20
#attn_method='sub'
#self_teach_num=1
#
#export CUDA_VISIBLE_DEVICES='5'
#save_dir="./outputs/self_training_sample/sample_uniform_${dataset_target}"
#mkdir -p $save_dir
#
#nohup python \
#  attempt/seq2seq/sample_pseudo.py \
#  --json_file $json_file \
#  --dataset_target $dataset_target \
#  --fewshot \
#  --fewshot_num $fewshot_num \
#  --attn_method $attn_method \
#  --save_dir $save_dir \
#  --self_teach_num $self_teach_num \
#  --self_train \
#  --self_train_source_dir $save_dir \
#  > ${save_dir}/debug.log 2>&1 &
#
####
#dataset_target='mrpc'
#json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
#fewshot_num=20
#attn_method='sub'
#self_teach_num=1
#
#export CUDA_VISIBLE_DEVICES='6'
#save_dir="./outputs/self_training_sample/sample_uniform_${dataset_target}"
#mkdir -p $save_dir
#
#nohup python \
#  attempt/seq2seq/sample_pseudo.py \
#  --json_file $json_file \
#  --dataset_target $dataset_target \
#  --fewshot \
#  --fewshot_num $fewshot_num \
#  --attn_method $attn_method \
#  --save_dir $save_dir \
#  --self_teach_num $self_teach_num \
#  --self_train \
#  --self_train_source_dir $save_dir \
#  > ${save_dir}/debug.log 2>&1 &
#
####
#dataset_target='stsb'
#json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
#fewshot_num=20
#attn_method='sub'
#self_teach_num=1
#
#export CUDA_VISIBLE_DEVICES='7'
#save_dir="./outputs/self_training_sample/sample_uniform_${dataset_target}"
#mkdir -p $save_dir
#
#nohup python \
#  attempt/seq2seq/sample_pseudo.py \
#  --json_file $json_file \
#  --dataset_target $dataset_target \
#  --fewshot \
#  --fewshot_num $fewshot_num \
#  --attn_method $attn_method \
#  --save_dir $save_dir \
#  --self_teach_num $self_teach_num \
#  --self_train \
#  --self_train_source_dir $save_dir \
#  > ${save_dir}/debug.log 2>&1 &