#!/bin/bash
dataset='superglue-multirc'
json_file="./attempt/configs/attempt/target_${dataset}.json"

# full or few-shot
eval_size='full'

self_train_path="./outputs/self_training/train_loss_entire_${dataset}"
export CUDA_VISIBLE_DEVICES='5'

save_dir="./outputs/self_training/train_loss_entire_${dataset}_${eval_size}_2"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/run_seq2seq.py $json_file $dataset $self_train_path $save_dir $eval_size\
  > ${save_dir}/debug.log 2>&1 &

