#!/bin/bash

#!/bin/bash
dataset_target='superglue-cb'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=20
seed_start=0
attn_method="sub"
self_teach_num=5
idx_lst="5"
attention_size_input=100
attention_size_output=100
hloss=0
dropout=0
model_name="t5-3b"
prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/attempt_3b_source_2"
prompt_embedding_path_model="t5-3b"
per_device_train_batch_size=4
per_device_eval_batch_size=4


export CUDA_VISIBLE_DEVICES='3'
save_dir="./outputs/baselines/test_source_val/full/${model_name}/${dataset_target}_idx_${idx_lst}"
mkdir -p $save_dir


nohup python \
  attempt/seq2seq/vote_attn_new.py \
  --test_only \
  --test_with_val \
  --dropout $dropout \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --fewshot_num $fewshot_num \
  --idx_lst $idx_lst \
  --attention_size_output $attention_size_output \
  --attention_size_input $attention_size_input \
  --hloss $hloss \
  --prompt_embedding_path_prefix $prompt_embedding_path_prefix \
  --prompt_embedding_path_model $prompt_embedding_path_model \
  --update_path_original \
  --model_name $model_name \
  --neural_deal \
  --seed_start $seed_start \
  --per_device_eval_batch_size $per_device_eval_batch_size \
  --per_device_train_batch_size $per_device_train_batch_size \
  > ${save_dir}/debug.log 2>&1 &