#!/bin/bash
dataset_target='superglue-cb'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=10
seed_start=0
attn_method="sub"
self_teach_num=5
idx_lst="0,1,2,3,4,5"
attention_size_input=100
attention_size_output=100
hloss=0
dropout=0
model_name="t5-3b"
prompt_embedding_path_model="t5-3b"
#load_idxs="/export/home/OpenPrompt/mixture_prompt/outputs/baselines/init_pt_fewshot_table/${model_name}/summary/${dataset_target}.pickle"
load_idxs="/export/home/OpenPrompt/mixture_prompt/outputs/baselines/sim-prompt/summary/${model_name}/${dataset_target}_1.pickle"
prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/outputs/baselines/source_fewshot/${model_name}"



export CUDA_VISIBLE_DEVICES='2'
save_dir="./outputs/baselines/spot-fs/${model_name}/${dataset_target}"
mkdir -p $save_dir


nohup python \
  attempt/seq2seq/vote_attn_new.py \
  --test_only \
  --eval_acc \
  --load_idxs $load_idxs \
  --dropout $dropout \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --fewshot_num $fewshot_num \
  --idx_lst $idx_lst \
  --attention_size_output $attention_size_output \
  --attention_size_input $attention_size_input \
  --hloss $hloss \
  --prompt_embedding_path_prefix $prompt_embedding_path_prefix \
  --prompt_embedding_path_model $prompt_embedding_path_model \
  --fewshot_update_prefix \
  --model_name $model_name \
  --neural_deal \
  --seed_start $seed_start \
  > ${save_dir}/debug.log 2>&1 &