#!/bin/bash
dataset_target='superglue-wsc.fixed'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=20
seed_start=0
attn_method="sub"
self_teach_num=5
idx_lst="0,1,2,3,4,5"
attention_size_input=100
attention_size_output=100
hloss=100
dropout=0
prompt_embedding_path_model="t5-base"
model_name="t5-base"
#prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/attempt_3b_source_2"
prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/outputs/baselines/source_fewshot/${model_name}"
export CUDA_VISIBLE_DEVICES='2'
save_dir="./outputs/vote_attn_table/uniform-fs/${prompt_embedding_path_model}/${dataset_target}"
mkdir -p $save_dir

#  --update_sp
#  --neural_deal \
# --update_path_original \
nohup python \
  attempt/seq2seq/vote_attn_new.py \
  --dropout $dropout \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --fewshot_num $fewshot_num \
  --idx_lst $idx_lst \
  --attention_size_output $attention_size_output \
  --attention_size_input $attention_size_input \
  --hloss $hloss \
  --prompt_embedding_path_prefix $prompt_embedding_path_prefix \
  --prompt_embedding_path_model $prompt_embedding_path_model \
  --fewshot_update_prefix \
  --model_name $model_name \
  --neural_deal \
  --seed_start $seed_start \
  --test_only \
  > ${save_dir}/debug.log 2>&1 &