#!/bin/bash
dataset_target="superglue-wic"
json_file="./attempt/configs/fewshot/target_naked.json"
#dataset_target="superglue-wsc.fixed_ppt"
attn_method="sub"
self_teach_num=5
fewshot_num=20
idx_lst="5"
attention_size_input=128
attention_size_output=64
hloss=100
prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/attempt_3b_source"
model_name="t5-3b"
export CUDA_VISIBLE_DEVICES='3'
prompt_embedding_path_model="t5-3b"

save_dir="./outputs/baselines/source_test/${prompt_embedding_path_model}/${dataset_target}_idx_${idx_lst}_original_vote"


mkdir -p $save_dir

#  --update_sp
nohup python \
  attempt/seq2seq/vote_attn_new.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --fewshot_num $fewshot_num \
  --idx_lst $idx_lst \
  --attention_size_output $attention_size_output \
  --attention_size_input $attention_size_input \
  --hloss $hloss \
  --prompt_embedding_path_prefix $prompt_embedding_path_prefix \
  --prompt_embedding_path_model $prompt_embedding_path_model \
  --model_name $model_name \
  --update_path_original \
  --neural_deal \
  > ${save_dir}/debug.log 2>&1 &