#!/bin/bash

json_file="./attempt/configs/ppt/source.json"
save_dir="./outputs/prompt_tuning_ppt/uni_t5_3b_sd_4"
mkdir -p $save_dir


NUM_GPUS_PER_WORKER=8 # number of gpus used on one node
NUM_NODES=2
MASTER_PORT=${1-1234}
export CUDA_VISIBLE_DEVICES='0,1,2,3,4,5,6,7'

nohup python -m torch.distributed.launch \
  --nproc_per_node ${NUM_GPUS_PER_WORKER} \
  attempt/seq2seq/run_seq2seq.py \
  --save_dir $save_dir \
  --json_file $json_file \
  --multiGpu \
  > ${save_dir}/debug.log 2>&1 &