#!/bin/bash
dataset='squad'
model_name="t5-base"
json_file="./attempt/configs/attempt/source_record.json"

save_dir="./outputs/prompt_tuning_teachers/t5-base_${dataset}_seed_4"
mkdir -p $save_dir

NUM_GPUS_PER_WORKER=4 # number of gpus used on one node
NUM_NODES=2
#MASTER_PORT=${1-1234}
export CUDA_VISIBLE_DEVICES='0,1,2,3,4,5,6,7'

nohup python -m torch.distributed.launch \
  --nproc_per_node ${NUM_GPUS_PER_WORKER} \
  attempt/seq2seq/run_seq2seq.py \
  --save_dir $save_dir \
  --json_file $json_file \
  --multiGpu \
  --dataset_source $dataset \
  --model_name $model_name \
  > ${save_dir}/debug.log 2>&1 &