#!/bin/bash
dataset_target='superglue-cb'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=10
seed_start=0
attn_method="sub"
self_teach_num=5
idx_lst="0,1,2,3,4,5"
attention_size_input=100
attention_size_output=100
hloss=500
dropout=0
prompt_embedding_path_model="t5-base"
model_name="t5-base"
#prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/attempt_3b_source"
prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/outputs/baselines/source_fewshot/${model_name}"
export CUDA_VISIBLE_DEVICES='7'
# ${attention_size_input}_${attention_size_output}_h_${hloss}_sd_${seed_start}
save_dir="./outputs/vote_attn_table-uw_att/${prompt_embedding_path_model}/${dataset_target}_${attention_size_input}_${attention_size_output}_h_${hloss}_sd_${seed_start}_dr_${dropout}"
#save_dir="./outputs/vote_attn_table/${prompt_embedding_path_model}/${dataset_target}_emseb"
#save_dir="/export/home/OpenPrompt/mixture_prompt/outputs/vote_attn/${dataset_target}_${attention_size_input}_${attention_size_output}_h_${hloss}_sd_${seed_start}_dr_${dropout}"
mkdir -p $save_dir

#  --update_sp
#  --neural_deal \
nohup python \
  attempt/seq2seq/vote_attn_new.py \
  --dropout $dropout \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --idx_lst $idx_lst \
  --attention_size_output $attention_size_output \
  --attention_size_input $attention_size_input \
  --hloss $hloss \
  --prompt_embedding_path_prefix $prompt_embedding_path_prefix \
  --prompt_embedding_path_model $prompt_embedding_path_model \
  --fewshot_update_prefix \
  --attention_uw \
  --model_name $model_name \
  --neural_deal \
  --seed_start $seed_start \
  > ${save_dir}/debug.log 2>&1 &