#!/bin/bash
dataset_target='superglue-multirc'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=20
attn_method='weight_more'

export CUDA_VISIBLE_DEVICES='0'
save_dir="./outputs/attempt_fewshot_linear_more_${dataset_target}"
mkdir -p $save_dir

#nohup python \
#  attempt/seq2seq/few_shot.py $json_file $fewshot $datase_target $attn_method\
#  > ${save_dir}/debug.log 2>&1 &
nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  > ${save_dir}/debug.log 2>&1 &