import jsonlines
from collections import Counter
from tqdm import tqdm
import argparse
import csv

def read_jsonlines(eval_file_name):
    lines = []
    print("loading examples from {0}".format(eval_file_name))
    with jsonlines.open(eval_file_name) as reader:
        for obj in reader:
            lines.append(obj)
    return lines[1:]


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_fp', type=str, default=None)
    parser.add_argument('--output_fp', type=str, default=None)
    args = parser.parse_args()

    data = read_jsonlines(args.input_fp)
    with open(args.output_fp, "w") as f:
        writer = csv.writer(f)
        writer.writerow(["question", "context", "answers"])
        for item in data:
            context = item["context"].replace("<P> ", "").replace(" </P> ", "").replace("\n", "")
            for qa in item["qas"]:
                writer.writerow([qa["question"], context, qa["answers"][0]])

if __name__ == "__main__":
    main()