#!/bin/bash
dataset_target='superglue-cb'
json_file="./attempt/configs/fewshot/fewshot_naked.json"
fewshot_num=20
model_name="t5-3b"
# full or few-shot
eval_dataset_type='full'

export CUDA_VISIBLE_DEVICES='7'
save_dir="./outputs/baselines/init_pt_fewshot_table/${model_name}/${dataset_target}"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --save_dir $save_dir \
  --eval_dataset_type $eval_dataset_type \
  --model_name $model_name\
  --init_prompt \
  > ${save_dir}/debug.log 2>&1 &