#!/bin/bash
dataset_target='superglue-rte'
export CUDA_VISIBLE_DEVICES='0'
source="squad"
model_name="t5-base"
fewshot_size=128
json_file="./attempt/configs/fewshot/fewshot_naked.json"
fewshot_num=5
# full or few-shot
eval_dataset_type='full'
#target_prompt_embedding_path="/export/home/OpenPrompt/mixture_prompt/outputs/prompt_tuning_ppt/uni_t5_large_sd_4/prefix_embeddings.pt"
#target_prompt_embedding_path="/export/home/OpenPrompt/mixture_prompt/outputs/prompt_tuning_ppt/uni_ppt_6gpu/prefix_embeddings.pt"

target_prompt_embedding_path="/export/home/OpenPrompt/mixture_prompt/source_prompts/${source}_prompt.pt"

save_dir="./outputs/baselines/source_fewshot_128/${model_name}/${dataset_target}_${source}_2"

#save_dir="./outputs/baselines/ppt-fs-128_2/${model_name}/${dataset_target}"

mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --save_dir $save_dir \
  --eval_dataset_type $eval_dataset_type \
  --model_name $model_name\
  --fewshot_source \
  --fewshot_size $fewshot_size \
  --target_prompt_embedding_path $target_prompt_embedding_path \
  > ${save_dir}/debug.log 2>&1 &