#!/bin/bash
dataset_target='superglue-multirc'
json_file="./attempt/configs/fewshot/fewshot_naked.json"
fewshot_num=20
model_name="t5-3b"
# full or few-shot
eval_dataset_type='full'
source="qqp"
target_prompt_embedding_path="/export/home/OpenPrompt/mixture_prompt/attempt_large_source/${source}_prefix_embeddings.pt"

export CUDA_VISIBLE_DEVICES='3'
save_dir="./outputs/baselines/source_fewshot_table/${dataset_target}_${source}_t5_large"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --save_dir $save_dir \
  --eval_dataset_type $eval_dataset_type \
  --model_name $model_name\
  --fewshot_source \
  --target_prompt_embedding_path $target_prompt_embedding_path \
  > ${save_dir}/debug.log 2>&1 &