#!/bin/bash
dataset_target='superglue-cb'
json_file="./attempt/configs/fewshot/fewshot_naked.json"
fewshot_num=5
model_name="t5-base"
# full or few-shot
eval_dataset_type='full'
target_prompt_embedding_path="/export/home/OpenPrompt/mixture_prompt/outputs/prompt_tuning_ppt/uni_ppt_6gpu/prefix_embeddings.pt"

export CUDA_VISIBLE_DEVICES='3'
save_dir="./outputs/baselines/ppt_full/${model_name}/${dataset_target}"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --data_full \
  --fewshot_num $fewshot_num \
  --save_dir $save_dir \
  --eval_dataset_type $eval_dataset_type \
  --model_name $model_name\
  --fewshot_source \
  --target_prompt_embedding_path $target_prompt_embedding_path \
  > ${save_dir}/debug.log 2>&1 &