#!/bin/bash
dataset_target='superglue-wsc.fixed'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=5
fewshot_num_begin=0
attn_method='sub'
eval_dataset_type='full'
prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/source_prompts"
model_name='t5-base'
per_device_train_batch_size=32
per_device_eval_batch_size=32
fewshot_size=128

export CUDA_VISIBLE_DEVICES='5'
save_dir="./outputs/baselines/attempt-128/${model_name}/${dataset_target}_sd_${fewshot_num_begin}"
mkdir -p $save_dir
#   --data_full \

#NUM_GPUS_PER_WORKER=8 # number of gpus used on one node
#NUM_NODES=1
#MASTER_PORT=${1-1234}
#export CUDA_VISIBLE_DEVICES='0,1,2,3,4,5,6,7'
#deepseed_path="./attempt/configs/deepseed/ds_fp32.json"
#nohup python \
#nohup python -m torch.distributed.launch \
#  --nproc_per_node ${NUM_GPUS_PER_WORKER} \
# --deepspeed $deepseed_path \
#deepspeed --num_gpus=8 \
nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --eval_dataset_type $eval_dataset_type \
  --fewshot_num_begin $fewshot_num_begin \
  --update_path_original \
  --prompt_embedding_path_prefix $prompt_embedding_path_prefix \
  --model_name $model_name \
  --per_device_eval_batch_size $per_device_eval_batch_size \
  --per_device_train_batch_size $per_device_train_batch_size \
  --fewshot_size $fewshot_size \
  > ${save_dir}/debug.log 2>&1 &