#!/bin/bash
dataset_target='superglue-cb'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=20
attn_method='sub'
self_teach_num=1

export CUDA_VISIBLE_DEVICES='2'
save_dir="./outputs/self_training/self_teach_${dataset_target}_pra"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/self_pseudo_add.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  > ${save_dir}/debug.log 2>&1 &