#!/bin/bash
dataset_target='superglue-wic'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=1
seed_start=0
attn_method="sub"
self_teach_num=5
idx_lst="0,1,2,3,4,5"
prompt_embedding_path_model="t5-base"
model_name="t5-base"
prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/outputs/baselines/source_full/t5-base"
export CUDA_VISIBLE_DEVICES='0'

save_dir="./outputs/baselines/eval_vote/full/${model_name}/${dataset_target}"
load_eval_vote_file="./outputs/baselines/eval_vote/${model_name}/summary/eval_vote.pickle"
mkdir -p $save_dir

#  --update_sp
#  --neural_deal \
nohup python \
  attempt/seq2seq/vote_attn_new.py \
  --eval_acc \
  --load_eval_vote_file $load_eval_vote_file \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --fewshot_num $fewshot_num \
  --idx_lst $idx_lst \
  --prompt_embedding_path_prefix $prompt_embedding_path_prefix \
  --prompt_embedding_path_model $prompt_embedding_path_model \
  --fewshot_update_prefix \
  --model_name $model_name \
  --neural_deal \
  --seed_start $seed_start \
  --test_only \
  --full_dataset \
  > ${save_dir}/debug.log 2>&1 &