#!/bin/bash
name="superglue-cb"
dataset_target="${name}_ppt"
json_file="./attempt/configs/ppt/target_${name}.json"
fewshot_num=5
attn_method="sub"
self_teach_num=5
idx_lst="0"
model_name="t5-base"
#prompt_embedding_path_prefix="./outputs/prompt_tuning_ppt/uni_t5_3b_sd_4/prefix_embeddings.pt"
prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/outputs/baselines/ppt-fs-128_2/${model_name}"
export CUDA_VISIBLE_DEVICES='2'


save_dir="./outputs/baselines/ppt-fs-128-test/${model_name}/${name}"


mkdir -p $save_dir

#  --update_sp
nohup python \
  attempt/seq2seq/vote_attn_new.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --neural_deal \
  --fewshot_num $fewshot_num \
  --idx_lst $idx_lst \
  --fs_update_one_prompt_seed \
  --prompt_embedding_path_prefix $prompt_embedding_path_prefix \
  --test_only \
  --model_name $model_name \
  > ${save_dir}/debug.log 2>&1 &