#!/bin/bash

dataset_target='superglue-multirc'
json_file="./attempt/configs/ppt/target_mrpc.json"
model_name="t5-base"
source='squad'
idx_lst='0'
prompt_embedding_path_model="t5-base"
prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/source_prompts/${source}_prompt.pt"

export CUDA_VISIBLE_DEVICES='0'
save_dir="/export/home/OpenPrompt/mixture_prompt/outputs/baselines/source_test/${prompt_embedding_path_model}/${source}_${dataset_target}_source_swap"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/vote_attn_new.py \
  --json_file $json_file \
  --model_name $model_name \
  --prompt_embedding_path_prefix $prompt_embedding_path_prefix \
  --save_dir $save_dir \
  --idx_lst $idx_lst \
  --dataset_target $dataset_target \
  --ppt_update_prefix \
  --test_only \
  --fewshot \
  > ${save_dir}/debug.log 2>&1 &