#!/bin/bash
dataset_target='wnli'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
model_name_or_path="/export/home/OpenPrompt/mixture_prompt/outputs/self_training/self_fs_s_source_dataset_t_target_dataset"
fewshot_num=20
attn_method='sub'
self_teach_num=5
dataset_source="mnli"

export CUDA_VISIBLE_DEVICES='0'
save_dir="./outputs/unsuper/unsp_${dataset_target}"
mkdir -p $save_dir

python \
  attempt/seq2seq/unsupervised.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --self_teach_num $self_teach_num \
  --self_train \
  --model_name_or_path $model_name_or_path \
  --dataset_source $dataset_source
  > ${save_dir}/debug.log 2>&1 &