from dataclasses import dataclass

import gym

import embodied
import shapes_envs


@dataclass(slots=True)
class ShapesConfig:
    task: str
    task_kwargs: dict
    use_agent: bool
    obs_size: int


# config = {"task": "nav_5x5",
#      "task_kwargs": dict(),
#      "use_agent": False,
#      "obs_size": 64,
#      }
# config = ShapesConfig(task="nav_5x5", task_kwargs={}, use_agent=False, obs_size=64)

# env = shapes_envs.ShapesEnv(config, seed=42)
env = gym.make('Navigation5x5-v0', apply_api_compatibility=True, seed=42)
print(env.reset())
print(env.step(env.action_space.sample()))
