import gym
import numpy as np


norm = lambda x: np.linalg.norm(x)


class GymToGymnasium(gym.Wrapper):
    def __init__(self, env):
        super().__init__(env)

    def reset(self, seed=None, options=None):
        observation = self.env.reset()
        return observation, {'is_success': False}

    def step(self, action):
        observation, reward, done, info = self.env.step(action)
        truncated = self.env.step_count >= self.env._max_steps
        terminated = done and not truncated
        return observation, reward, terminated, truncated, info
