#!/bin/bash

export WANDB_API_KEY=

SEED=0
ENT=0.01
EPOCHS=10
CLIP=0.2
suffix="-ent-0-01-epochs-10"
ocr_checkpoint_path=checkpoints/pushing7x7/model_best.pth
group=pushing7x7"$suffix"
run_name="$group"_$SEED
entity=

python train_sb3.py ocr=slate_navigation5x5 ocr.slotattr.num_slots=6 pooling=transformer sb3=ppo sb3.algo_kwargs.ent_coef=$ENT sb3.algo_kwargs.n_epochs=$EPOCHS sb3.algo_kwargs.clip_range=$CLIP sb3_acnet=mlp pooling.ocr_checkpoint.local_file=$ocr_checkpoint_path tags='ocrl_pushing7x7' device=0 env=pushing7x7 env.tags='Pushing7x7' seed=$SEED wandb.entity=$entity wandb.project=ocrl_pushing7x7 wandb.group="$group" wandb.name=$run_name 2>&1 | tee pushing7x7_log-$SEED.txt
