#!/bin/bash

export WANDB_API_KEY=

ENT=0.01
EPOCHS=10
CLIP=0.2
suffix="-ent-0-01-epochs-10-clip-0-2"
entity=
project=ocrl_robosuite-lift
group=slots5"$suffix"
path=checkpoints/robosuite-lift/77qt0dzq.ckpt

SEED=0
name="$group"_$SEED
python train_sb3.py ocr=dinosaur_robosuite_lift ocr.slotattr.num_slots=5 ocr.slotattr.slot_size=64 pooling=transformer sb3=ppo sb3.algo_kwargs.ent_coef=$ENT sb3.algo_kwargs.n_epochs=$EPOCHS sb3.algo_kwargs.clip_range=$CLIP sb3_acnet=mlp pooling.ocr_checkpoint.local_file="$path" tags='ocrl_robosuite-lift' device=0 env=robosuite_lift env.tags='Robosuite-Lift' seed=$SEED num_envs=1 wandb.entity=$entity wandb.project=$project wandb.group=$group wandb.name=$name 2>&1 | tee ocrl-dinosaur_robosuite-lift"$suffix"_log-$SEED.txt

