import gym
import gymnasium
import numpy as np
from vizdoom import gymnasium_wrapper
from PIL import Image

import envs


class VizDoom(gym.Env):
    metadata = {"render.modes": ["rgb_array"]}

    def __init__(self, scenario, size=224):
        self._scenario = scenario
        self._size = size
        self._env = gymnasium.make(scenario, render_mode='rgb_array')
        self.observation_space = gym.spaces.Box(0, 255, (self._size, self._size, 3), dtype=np.uint8)
        self.action_space = gym.spaces.Discrete(self._env.action_space.n)

    def _resize(self, image):
        return np.asarray(Image.fromarray(image).resize((self._size, self._size)))

    def reset(self):
        image = self._env.reset()[0]['screen']
        return self._resize(image)

    def step(self, action):
        observation, reward, terminated, truncated, info = self._env.step(action)
        done = terminated or truncated
        if truncated:
            info['TimeLimit.truncated'] = True

        return self._resize(observation['screen']), reward, done, info

    def seed(self, seed=None):
        self._env.reset(seed=seed)

    def render(self, mode=None):
        return self._env.render()

    def close(self):
        return self._env.close()
