clear;
clc
folder_now = pwd;
addpath([folder_now, '/funs']);
addpath([folder_now, '/dataset/']);
addpath([folder_now, '/measure/']);

dataname=[ "scene15" ];%"MSRCv1" "NGs" "HW" "BBCSport" "scene15" "Aloi-100" "cifar10" "Caltech101-all"
for it_name = 1:length(dataname)
    load(strcat(dataname(it_name),'.mat'));
    if dataname(it_name)~="ORL" && dataname(it_name)~="scene15" && dataname(it_name)~="UCI" && dataname(it_name)~="still-2"&& dataname(it_name)~="VGGFace2-50"
        gt=truelabel{1};
        X=data;%dv by n
    end
    if dataname(it_name)=="VGGFace2-50"
        gt=Y;
        for i =1:length(X)
            X{i}=X{i}';
        end
    end
    if size(gt,1) ==1
        gt=gt';S
    end
    V=length(X);
    N = size(X{1},2);% number of data poin
    cls_num=length(unique(gt));
    if dataname(it_name)=="MSRCv1"
        numanchor=cls_num; alpha=0.01;beta=0.001;gamma=0.01;delta=1;
    elseif dataname(it_name)== "NGs"
        numanchor=cls_num; alpha=0.1;beta=0.01;gamma=0.01;delta=1;
    elseif dataname(it_name)== "HW"
        numanchor=cls_num; alpha=0.001;beta=0.01;gamma=0.001;delta=1;
    elseif dataname(it_name)== "BBCSport"
        numanchor=cls_num; alpha=0.01;beta=0.001;gamma=0.001;delta=1;
    elseif dataname(it_name)== "scene15"
        numanchor=2*cls_num; alpha=0.1;beta=0.001;gamma=1;delta=0.3;
    elseif dataname(it_name)== "Aloi-100"
        numanchor=2*cls_num; alpha=1;beta=0.001;gamma=10;delta=1;
    elseif dataname(it_name)== "cifar10"
        numanchor=cls_num; alpha=0.1;beta=0.01;gamma=0.001;delta=1;
    elseif dataname(it_name)== "Caltech101-all"
        numanchor=cls_num; alpha=0.1;beta=0.01;gamma=100;delta=0.5;
    end
    
    
    %normalized X
    for i=1:V
        X{i} = X{i}./repmat( max(1e-12*ones(1,N),sqrt(sum(X{i}.^2,1))),size(X{i},1),1);
        %    for j = 1:N
        %      X{i}(:,j)  = X{i}(:,j) ./ max(1e-12,norm(X{i}(:,j)));
        % end
    end
    
    for j=1:10
        % Perform K-Means on each view
        parfor i=1:V
            % rand('twister',5489);
            rng(5489,'twister');
            [~, H{i}] = litekmeans(X{i}',numanchor,'MaxIter', 100,'Replicates',10);
            A{i}=H{i}';
        end
        tic;
        % Core part of this code (LMVSC)
        [labels] = STONE(X,gt,A,alpha,beta,gamma,delta);
        % Performance evaluation of clustering result
        score(j,:) =  ClusteringMeasure(gt, labels);
        t(j,:)=toc;
    end
    re_mean = mean(score);
    re_std = std(score);
    re_t=mean(t);
    save('result_STONE_'+dataname(it_name),'re_mean','re_std','re_t')
    
    % Write the evaluation results to a text file
    
end
