clear;
clc
folder_now = pwd;
addpath([folder_now, '/funs']);
addpath([folder_now, '/dataset/']);
addpath([folder_now, '/measure/']);

dataname=[ "BBCSport"];%"BBCSport","HW","MSRCv1","ORL","100leaves","CCV"
for it_name = 1:length(dataname)
    load(strcat(dataname(it_name),'.mat'));
    if dataname(it_name)~="ORL" && dataname(it_name)~="scene15" && dataname(it_name)~="UCI" && dataname(it_name)~="still-2"&& dataname(it_name)~="VGGFace2-50"
        gt=truelabel{1};
        X=data;%dv by n
    end
    if dataname(it_name)=="VGGFace2-50"
        gt=Y;
        for i =1:length(X)
            X{i}=X{i}';
        end
    end
    if size(gt,1) ==1
        gt=gt';
    end
    V=length(X);
    N = size(X{1},2);% number of data poin
    cls_num=length(unique(gt));

    numanchor=[cls_num ];%cls_num 2*cls_num 3*cls_num 4*cls_num 5*cls_num 6*cls_num 7*cls_num
    alpha=[1e-5 1e-4 1e-3 1e-2   0.1 1 10 100 ];%1e-5 1e-4 1e-3 1e-2   0.1 1 10 100
    beta=[1e-5 1e-4 1e-3 1e-2   0.1 1 10 100  ];%1e-5 1e-4 1e-3 1e-2   0.1 1 10 100
    gamma=[ 1e-5 1e-4 1e-3 1e-2   0.1 1 10 100  ];%1e-5 1e-4 1e-3 1e-2   0.1 1 10 100
    delta=[ 1e-5 1e-4 1e-3 1e-2   0.1 1 10 100  ];
    bestacc=0;
    %normalized X
    for i=1:V
        X{i} = X{i}./repmat( max(1e-12*ones(1,N),sqrt(sum(X{i}.^2,1))),size(X{i},1),1);
        %    for j = 1:N
        %      X{i}(:,j)  = X{i}(:,j) ./ max(1e-12,norm(X{i}(:,j)));
        % end
    end
    
    
    for j=1:length(numanchor)
        
        % Perform K-Means on each view
        parfor i=1:V
            % rand('twister',5489);
            rng(5489,'twister');
            [~, H{i}] = litekmeans(X{i}',numanchor(j),'MaxIter', 100,'Replicates',10);
            A{i}=H{i}';
        end
        
        for i=1:length(alpha)
            for k=1:length(beta)
                for m=1:length(gamma)
                    for n=1:length(delta)
                        fprintf('params:\tnumanchor=%d\t\talpha=%f\tbeta=%f\n',numanchor(j),alpha(i),beta(k));
                        tic;
                        
                        % Core part of this code (LMVSC)
                        [labels] = STONE(X,gt,A,alpha(i),beta(k),gamma(m),delta(n));
                        
                        % Performance evaluation of clustering result
                        result =  ClusteringMeasure(gt, labels);
                         t=toc;
                        if result(1)>bestacc
                            bestacc=result(1);
                            dlmwrite('result/best_'+dataname(it_name)+'.txt',[numanchor(j)  alpha(i) beta(k) gamma(m) delta(n) result t],'-append','delimiter','\t','newline','pc');
                        end
                        fprintf('result:\t%12.6f %12.6f %12.6f %12.6f %12.6f %12.6f %12.6f\n',[result t]);
                        
                        % Write the evaluation results to a text file
                        dlmwrite('result/refertopara_'+dataname(it_name)+'.txt',[numanchor(j)  alpha(i) beta(k) gamma(m) delta(n) result t],'-append','delimiter','\t','newline','pc');
                    end
                end
            end
        end
    end
end