import os
import random
from PIL import Image
import numpy as np
from tqdm import tqdm
import torchvision
import torch

# Create output folders if they don't exist
colored_folder = 'data/mnist32/colored'
rotated_folder = 'data/mnist32/rotated'
os.makedirs(colored_folder, exist_ok=True)
os.makedirs(rotated_folder, exist_ok=True)

# Get MNIST dataset
mnist = torchvision.datasets.MNIST(root='./data', train=True, download=True)

# Process each image
for i in tqdm(range(len(mnist))):
    # Get image and ignore label
    img = mnist[i][0]
    
    # Resize to 32x32
    img = img.resize((32, 32), Image.BILINEAR)
    
    # Create colored version
    img_data = np.array(img).astype(np.float32)/255.0
    color = np.random.randint(0, 256, size=3).astype(np.float32)
    colored_data = img_data[..., None] * color
    colored_data = colored_data.astype(np.uint8)
    colored_img = Image.fromarray(colored_data)
    
    # Create rotated version
    angle = random.uniform(-70, 70)
    rotated_img = img.rotate(angle, expand=False)
    
    # Save colored image
    colored_path = os.path.join(colored_folder, f'mnist_{i}.jpg')
    colored_img.save(colored_path, 'JPEG')
    
    # Save rotated image
    rotated_path = os.path.join(rotated_folder, f'mnist_{i}.jpg')
    rotated_img.save(rotated_path, 'JPEG')
