from rdkit import Chem
from rdkit.Chem.rdchem import BondType as BT


pt = Chem.GetPeriodicTable()

token_names = [
    f"*{atomic_number}" for atomic_number in range(1, 119)
] + ["*UNKMolAtom"]

mol_unk_token_name = "*UNKMolAtom"
mol_atom_name = "*MolAtom"

atom_types = [mol_atom_name]

edge_types = ["bond"]

token_name_to_atom_type = {tn: mol_atom_name for tn in token_names}

allowable_features = {
    'possible_chirality_list': [
        'CHI_UNSPECIFIED',
        'CHI_TETRAHEDRAL_CW',
        'CHI_TETRAHEDRAL_CCW',
        'CHI_OTHER'
    ],
    'possible_degree_list': [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 'misc'],
    'possible_numring_list': [0, 1, 2, 3, 4, 5, 6, 'misc'],
    'possible_implicit_valence_list': [0, 1, 2, 3, 4, 5, 6, 'misc'],
    'possible_formal_charge_list': [-5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 'misc'],
    'possible_numH_list': [0, 1, 2, 3, 4, 5, 6, 7, 8, 'misc'],
    'possible_number_radical_e_list': [0, 1, 2, 3, 4, 'misc'],
    'possible_hybridization_list': [
        'SP', 'SP2', 'SP3', 'SP3D', 'SP3D2', 'misc'
    ],
    'possible_is_aromatic_list': [False, True],
    'possible_is_in_ring3_list': [False, True],
    'possible_is_in_ring4_list': [False, True],
    'possible_is_in_ring5_list': [False, True],
    'possible_is_in_ring6_list': [False, True],
    'possible_is_in_ring7_list': [False, True],
    'possible_is_in_ring8_list': [False, True],
}

bond_types = {BT.UNSPECIFIED:0, BT.SINGLE: 1, BT.DOUBLE: 2, BT.TRIPLE: 3, BT.AROMATIC: 4}

chi_pi_periodic = [
    [0.0, 0.0, 0.0, 0.0] for toktype in token_names
]

# Here we do not distinguish between the radii of different atoms, using a unified value instead
# In code we extract the atom type by taking the first letter of the atom name,
# thus we need to use * to represent this
van_der_waals_radius = {
    "*": 1.5
}

extra_feat_num = sum(map(len, [
    allowable_features['possible_chirality_list'],
    allowable_features['possible_degree_list'],
    allowable_features['possible_formal_charge_list'],
    allowable_features['possible_implicit_valence_list'],
    allowable_features['possible_numH_list'],
    allowable_features['possible_number_radical_e_list'],
    allowable_features['possible_hybridization_list'],
    allowable_features['possible_is_aromatic_list'],
    allowable_features['possible_numring_list'],
    allowable_features['possible_is_in_ring3_list'],
    allowable_features['possible_is_in_ring4_list'],
    allowable_features['possible_is_in_ring5_list'],
    allowable_features['possible_is_in_ring6_list'],
    allowable_features['possible_is_in_ring7_list'],
    allowable_features['possible_is_in_ring8_list'],
]))

pair_feat_num = len(bond_types)

chi_angles_mask = [[0.0, 0.0, 0.0, 0.0]] * len(token_names)

chi_angles_atoms = {tokname: [] for tokname in token_names}

rigid_group_atom_positions = {
    tn: [
        [mol_atom_name, 0, (0.0, 0.0, 0.0)]
    ] for tn in token_names
}