# Maraboupy Documentation

This folder contains the files needed to build the Marabopy html documentation.

The documentation is built through sphinx, which can be installed with pip
(along with other required python packages) using
```
pip install -r requirements.txt
```
It is assumed that the maraboupy test requirements have already been installed.
If not, they can be installed with
```
pip install -r ../test_requirements.txt
```

Then, html files are built with make (assuming Linux OS) using
```
make html
```

This process pulls in information from python source files in the maraboupy folder
(parent directory of this folder) as well as python examples in the maraboupy/examples
folder. The output html documentation will be located in the created folder, \_build/html.

## Documentation organization

The configuration file conf.py contains important settings for building documentation,
including color schemes, sphinx extensions, and definitions of hyperlinks to source code 
on GitHub.

The index.rst file is the default page for the html documentation and sets up the navigation tree
for the documentation.

The Makefile was generated by sphinx and specifies the build variables and commands.

The API folder contains reStructedText files that are very bare, which uses sphinx to auto-generate
documentation from comment blocks in the source files. Note that the number prefixed to the file names is the
order in which the files will be used to create the documentation.

The Examples folder is created during the build process using the sphinx-gallery extension.

Additional folders, like Setup, contain markdown or reStructuredText files to provide additional documentation.
These folders must be added to the toctrees in index.rst in order to build corresponding html files.