from models.general_model_agent import GeneralAgent
from models.general_model_agent_CQL import GeneralAgent_CQL
from models.general_model_agent_offlinelight import GeneralAgent_Offline
from models.general_model_agent_BC import GeneralAgent_BC
from models.general_model_agent_TD3_BC import GeneralAgent_TD3_BC
from models.general_model_agent_BEAR import GeneralAgent_BEAR

DIC_AGENTS = {
    "General": GeneralAgent,
    "General_CQL": GeneralAgent_CQL,
    "General_offline": GeneralAgent_Offline,
    "General_BC": GeneralAgent_BC,
    "General_TD3_BC": GeneralAgent_TD3_BC,
    "General_BEAR": GeneralAgent_BEAR,
}

DIC_PATH = {
    "PATH_TO_MODEL": "model/default",
    "PATH_TO_WORK_DIRECTORY": "records/default",
    "PATH_TO_DATA": "data/template",
    "PATH_TO_PRETRAIN_MODEL": "model/default",
    "PATH_TO_ERROR": "errors/default",
}

dic_traffic_env_conf = {
    "MIN_Q_W": 0.005,
    "THRESHOLD": 0.3,
    
    "LIST_MODEL": ["General"],
    "LIST_MODEL_NEED_TO_UPDATE": ["General"],

    "MODEL_NAME": None,
    "TOP_K_ADJACENCY": 5,

    "ACTION_PATTERN": "set",
    "NUM_INTERSECTIONS": 1,

    "OBS_LENGTH": 167,
    "MIN_ACTION_TIME": 15,
    "MEASURE_TIME": 15,

    "BINARY_PHASE_EXPANSION": True,

    "YELLOW_TIME": 5,
    "ALL_RED_TIME": 0,
    "NUM_PHASES": 4,
    "NUM_LANES": [3, 3, 3, 3],

    "INTERVAL": 1,

    "PHASE_MAP": [[1, 4], [7, 10], [0, 3], [6, 9]],

    "NUM_LANE": 12,

    "LIST_STATE_FEATURE": [
        "cur_phase",
        "time_this_phase",
        "lane_num_vehicle",
        "lane_num_vehicle_downstream",
        "traffic_movement_pressure_num",
        "traffic_movement_pressure_queue",
        "traffic_movement_pressure_queue_efficient",
        "pressure",
        "adjacency_matrix"
    ],
    "LIST_STATE_FEATURE_TOTAL": [
        "lane_num_vehicle_in",
        "lane_num_vehicle_out",
        "lane_queue_vehicle_in",
        "lane_queue_vehicle_out",
        "traffic_movement_pressure_queue",
        "traffic_movement_pressure_queue_efficient",
        "lane_run_in_part",
        "lane_queue_in_part",
        "num_in_seg",
        "adjacency_matrix",
        "new_phase"
    ],
    "DIC_REWARD_INFO": {
        "queue_length": 0,
        "pressure": 0,
    },
    "PHASE": {
        1: [0, 1, 0, 1, 0, 0, 0, 0],
        2: [0, 0, 0, 0, 0, 1, 0, 1],
        3: [1, 0, 1, 0, 0, 0, 0, 0],
        4: [0, 0, 0, 0, 1, 0, 1, 0]
        },
}

DIC_BASE_AGENT_CONF = {
    "D_DENSE": 20,
    "LEARNING_RATE": 0.001,
    "PATIENCE": 10,
    "BATCH_SIZE": 1000,
    "EPOCHS": 1,
    "SAMPLE_SIZE": 3000,
    "MAX_MEMORY_LEN": 12000,

    "UPDATE_Q_BAR_FREQ": 5,
    "UPDATE_Q_BAR_EVERY_C_ROUND": False,

    "GAMMA": 0.8,
    "NORMAL_FACTOR": 20,

    "EPSILON": 0.8,
    "EPSILON_DECAY": 0.95,
    "MIN_EPSILON": 0.2,
    "LOSS_FUNCTION": "mean_squared_error",
}
