import os
import torch
from models import UTSReg, UvhMAE, UTSCls, SimmimReg, ImgMAE, MvhMAE, RegLinear, RegAttn, ClsLinear, ClsAttn


class Exp_Basic(object):
    def __init__(self, args):
        self.args = args
        self.data_dict = {}
        self.model_dict = {
            'UTSRegression': UTSReg,
            'mae_uvh': UvhMAE,
            'UTSClassification': UTSCls,
            'MiMRegression': SimmimReg,
            'MAE_RQ3': ImgMAE,
            'MVH_RQ3': MvhMAE,
            'Linear_RQ5': RegLinear,
            'Attn_RQ5': RegAttn,
            'Linear_Cls_RQ5': ClsLinear,
            'Attn_Cls_RQ5': ClsAttn
        }
        self.device = self._acquire_device()
        self.model = self._build_model().to(self.device)

    def _build_model(self):
        raise NotImplementedError

    def _acquire_device(self):
        if self.args.use_gpu:
            os.environ["CUDA_VISIBLE_DEVICES"] = str(
                self.args.gpu) if not self.args.use_multi_gpu else self.args.devices
            device = torch.device('cuda:{}'.format(self.args.gpu))
            print('Use GPU: cuda:{}'.format(self.args.gpu))
        else:
            device = torch.device('cpu')
            print('Use CPU')
        return device

    def _get_data(self):
        pass

    def vali(self):
        pass

    def train(self):
        pass

    def test(self):
        pass
