# load_model.py
from transformers import AutoModelForCausalLM, AutoTokenizer
from huggingface_hub import login
login(token='hf-token')

def load_model_and_tokenizer(model_name_or_path):
    tokenizer = AutoTokenizer.from_pretrained(model_name, trust_remote_code=True)
    model = AutoModelForCausalLM.from_pretrained(
        model_name,
        torch_dtype=torch.float16,
        device_map="auto", 
        trust_remote_code=True,
        output_attentions=True,
        output_hidden_states=True
    )
    model.eval()
    return model, tokenizer
