import matplotlib
import matplotlib.pyplot as plt
from matplotlib.pyplot import MultipleLocator
plt.rc('font',family='Times New Roman')
plt.switch_backend('agg')
import numpy as np
import numpy
import seaborn as sns
sns.set_theme(style = 'darkgrid')

from matplotlib.font_manager import FontProperties

matplotlib.rcParams['text.usetex'] = True
# matplotlib.rcParams['text.latex.unicode'] = True
plt.rc('text', usetex=True) #Use latex

'''
Task Averaged Regret with respect to the Number of Tasks over Gaussian Dataset
'''

font = {'size': 14}
matplotlib.rc('font', **font)

num_task = 10
tasks = np.array(list(range(1,num_task+1)))

single_task_10_shot_regret     = np.array([0.04532] * num_task)
meta_learn_10_shot_regret     = np.array([0.04532, 0.04496, 0.04209, 0.04077, 0.04236, 0.03952, 0.04005, 0.03664, 0.03550, 0.03480])

single_task_20_shot_regret     = np.array([0.03776] * num_task)
meta_learn_20_shot_regret     = np.array([0.03776, 0.03560, 0.03458, 0.03412, 0.03319, 0.03357, 0.03169, 0.02946, 0.02997, 0.02834])


single_task_10_shot_regret_plot, = plt.plot(tasks, single_task_10_shot_regret,  color='red', linestyle=':', linewidth=2, label='1-shot, single task')
single_task_10_shot_regret_plot_circle, = plt.plot(tasks, single_task_10_shot_regret, 'o', color='red') # ms=14
meta_learn_10_shot_regret_plot, = plt.plot(tasks, meta_learn_10_shot_regret,  color='green', linestyle=':', linewidth=2, label='1-shot, multi-task')
meta_learn_10_shot_regret_plot_circle, = plt.plot(tasks, meta_learn_10_shot_regret, 'o',color='green')

single_task_20_shot_regret_plot, = plt.plot(tasks, single_task_20_shot_regret, color='k', linewidth=2, label='5-shot, single task')
single_task_20_shot_regret_plot_square, = plt.plot(tasks, single_task_20_shot_regret, 's', color='k')
meta_learn_20_shot_regret_plot, = plt.plot(tasks, meta_learn_20_shot_regret, color='blue', linewidth=2, label='5-shot, multi-task')
meta_learn_20_shot_regret_plot_square, = plt.plot(tasks, meta_learn_20_shot_regret, 's', color='blue')

plt.ylabel('Task-Averaged Regret ' r'$\frac{\bar{R}_{T,m}}{m}$', fontsize=14, labelpad=2)

plt.xlabel('Number of Training Tasks ' r'$T$',fontsize=14,  labelpad=2)
plt.grid(True)
plt.xlim(0.5,10.5)

plt.ylim(0.027,0.050)

fontP = FontProperties()
fontP.set_size('small')
plt.tight_layout()

x_major_locator=MultipleLocator(1)
y_major_locator = MultipleLocator(0.003)

ax=plt.gca()
ax.xaxis.set_major_locator(x_major_locator)
ax.yaxis.set_major_locator(y_major_locator)

plt.legend([(single_task_10_shot_regret_plot, single_task_10_shot_regret_plot_circle ), (meta_learn_10_shot_regret_plot, meta_learn_10_shot_regret_plot_circle),
 (single_task_20_shot_regret_plot,single_task_20_shot_regret_plot_square), (meta_learn_20_shot_regret_plot, meta_learn_20_shot_regret_plot_square)], ["10-shot single-task", "10-shot multi-task", "20-shot single-task","20-shot multi-task"], loc='upper right', bbox_to_anchor=(18/20, 20/20), ncol=2, fontsize=14, prop=fontP)
plt.savefig('./gaussian_regret.pdf',dpi=200)
plt.show()