import matplotlib
import matplotlib.pyplot as plt
from matplotlib.pyplot import MultipleLocator
plt.rc('font',family='Times New Roman')
plt.switch_backend('agg')
import numpy as np
import numpy
import seaborn as sns
sns.set_theme(style = 'darkgrid')

from matplotlib.font_manager import FontProperties

matplotlib.rcParams['text.usetex'] = True
# matplotlib.rcParams['text.latex.unicode'] = True
plt.rc('text', usetex=True) #Use latex

'''
Task Averaged Regret with respect to the Sample Size per Task over Gaussian Dataset
'''

font = {'size': 14}
matplotlib.rc('font', **font)

num_task = 10
tasks = np.array(list(range(1,num_task+1)))

T_1_regret    = np.array([0.05232, 0.04491, 0.04093, 0.03504, 0.03286, 0.03071, 0.02635, 0.02483, 0.02559, 0.02322])

T_2_regret     = np.array([0.04898, 0.04216, 0.0336, 0.0309, 0.0294, 0.02737, 0.02498, 0.024, 0.02287, 0.02119])

T_3_regret    = np.array([0.04333, 0.03713, 0.03211, 0.02933, 0.02596, 0.02469, 0.02438, 0.02239, 0.02043, 0.02000])


T_1_regret_plot, = plt.plot(tasks, T_1_regret,  color='red', linewidth=2)
T_1_regret_plot_circle, = plt.plot(tasks, T_1_regret, 'o', color='red') 

T_2_regret_plot, = plt.plot(tasks, T_2_regret,  color='green', linewidth=2, label='1-shot, multi-task')
T_2_regret_plot_circle, = plt.plot(tasks, T_2_regret, 'o',color='green')

T_3_regret_plot, = plt.plot(tasks, T_3_regret, color='blue', linewidth=2)
T_3_regret_plot_circle, = plt.plot(tasks, T_3_regret, 'o', color='blue')

plt.ylabel('Task-Averaged Regret ' r'$\frac{\bar{R}_{T,m}}{m}$', fontsize=14, labelpad=2)

plt.xlabel('Number of Samples per Task ' r'$m$',fontsize=14,  labelpad=2)
plt.grid(True)
plt.xlim(0.5,num_task + 0.5)

x = range(1, num_task+1)
plt.xticks(x, [i * 5 for i in list(x)])

plt.ylim(0.019,0.054)

fontP = FontProperties()
fontP.set_size('medium')
plt.tight_layout()

# x_major_locator=MultipleLocator(1)
y_major_locator = MultipleLocator(0.004)

ax=plt.gca()
# ax.xaxis.set_major_locator(x_major_locator)
ax.yaxis.set_major_locator(y_major_locator)

plt.legend([(T_1_regret_plot, T_1_regret_plot_circle ), (T_2_regret_plot, T_2_regret_plot_circle),
 (T_3_regret_plot,T_3_regret_plot_circle)], [r"$T=1$", r"$T=5$", r"$T=10$"], loc='upper right', bbox_to_anchor=(19/20, 20/20), fontsize=14, prop=fontP)
plt.savefig('./gaussian_regret.pdf',dpi=200)
plt.show()