import numpy as np

DATA_DIR = 'ANONYMIZED_GAUSSIAN'

r = 10.0

c1 = np.asarray([0.0,0.0])
c2 = np.asarray([r,0.0])

cov = np.asarray([[1.0,0.0],[0.0,1.0]])

test = 20
train = 80
total= test+train

d1 = np.random.multivariate_normal(c1, cov, total)
d2 = np.random.multivariate_normal(c2, cov, total)

# uniform random biclusters with different amounts of separation
seps = [2.1,2.2,2.3,2.4,2.5,2.6,2.7,2.8,2.9,3.0]

def zipl(a,b):
    return [np.asarray([x,y]) for x,y in zip(a,b)]

def l2_dist(x, y):
    return np.linalg.norm(x-y)

ctr = -1
for sep in seps:
    ctr +=1
    T = 5 # T in [5, 50] for training tasks
    for itr in range(T):
        data = []
        labels = []
        rs = np.random.normal(0.5,0.5,200)
        x1s = rs[150:]
        x2s = rs[100:150]
        y1s = [r*0.5 for r in rs[50:100]]
        y2s = [(r+sep)*0.5 for r in rs[:50]]
        data = zipl(x1s,y1s) + zipl(x2s,y2s)
        labels = [0]*50+[1]*50
        tot = len(data)
        S = tot
        s = np.random.permutation(tot)
        xx = []
        yy = []
        ss = 0
        for j in s:
            xx.append(data[j])
            yy.append(labels[j])
        D = np.zeros((S, S))
        for a in range(S):
            for b in range(S):
                D[a][b] = l2_dist(xx[a],xx[b])
        np.savetxt(DATA_DIR+"/D-"+str(ctr)+"-"+str(itr)+"-of-"+str(T-1), D, delimiter=',')
        np.savetxt(DATA_DIR+"/y-"+str(ctr)+"-"+str(itr)+"-of-"+str(T-1), yy, delimiter=',')

