#include <fstream>
#include <vector>
#include <iterator>
#include <string>
#include <algorithm>
#include <sstream>
#include <iostream>
 
/*
 * A class to read data from a csv file.
 */
class CSVReader
{
	std::string fileName;
	std::string delimiter;
 
public:
	CSVReader(std::string filename, std::string delm = ",") :
			fileName(filename), delimiter(delm)
	{ }
 
	// Function to fetch matrix data from a CSV File.
	std::vector<std::vector<double> > getData();
	// Function to fetch vector data from a CSV File.
	std::vector<int> getLabels();
};
 
/*
* Parses through csv features file line by line and returns the data
* in vector of vector of strings.
*/
std::vector<std::vector<double> > CSVReader::getData() {
	std::ifstream file(fileName);
 
	std::vector<std::vector<double> > dataList;
 
	std::string line = "";
	while (getline(file, line)) {
		std::vector<std::string> vec;
		std::stringstream ss(line);
		std::string token;
		std::vector<double> m;
		while (getline(ss, token, ',')) {
			m.push_back(std::stod(token));
		}
		dataList.push_back(m);
	}
	file.close();
 
	return dataList;
}

/*
* Parses through label file line by line and returns the data
* in a vector of ints.
*/
std::vector<int > CSVReader::getLabels() {
	std::ifstream file(fileName);
 
	std::vector<int > dataList;
 
	std::string line = "";
	while (getline(file, line)) {
		dataList.push_back(std::stoi(line));
	}
	file.close();
 
	return dataList;
}
