#!/bin/bash

export PROJECT_ROOT="./"
export HYDRA_FULL_ERROR=1


common_args='model.img_size=32 datamodule.image_size=32 datamodule.batch_size=1024 model.drop_rate=0.0 model.drop_path_rate=0.1'

python3 -u run.py experiment=cifar10/mixer/mixers +task_name="cifar10-mixer-s-baseline" $common_args datamodule=cifar10 train.optimizer_param_grouping.bias_weight_decay=False train.optimizer_param_grouping.normalization_weight_decay=False
python3 -u run.py experiment=cifar10/mixer/mixers +task_name="cifar100-mixer-s-baseline" $common_args datamodule=cifar100 train.optimizer_param_grouping.bias_weight_decay=False train.optimizer_param_grouping.normalization_weight_decay=False
python3 -u run.py experiment=cifar10/vit/vit-s +task_name="cifar10-vit-s-baseline" $common_args datamodule=cifar10 train.optimizer_param_grouping.bias_weight_decay=False train.optimizer_param_grouping.normalization_weight_decay=False
python3 -u run.py experiment=cifar10/vit/vit-s +task_name="cifar100-vit-s-baseline" $common_args datamodule=cifar100 train.optimizer_param_grouping.bias_weight_decay=False train.optimizer_param_grouping.normalization_weight_decay=False


export IMAGENET_DIR=./data/ILSVRC/Data/CLS-LOC
common_args='model.img_size=224 datamodule.image_size=224 datamodule.batch_size=1024 model.drop_rate=0.0 model.drop_path_rate=0.1'
python3 -u run.py experiment=imagenet/vit/vit-b +tas_name="imagenet-vit-b-baseline" $common_args  trainer.devices=8 trainer.num_nodes=1 datamodule.num_workers=4 +trainer.strategy="ddp"  datamodule.data_dir=$IMAGENET_DIR