#!/bin/bash

export PROJECT_ROOT='./'
export HYDRA_FULL_ERROR=1
export IMAGENET_DIR=./data/ILSVRC/Data/CLS-LOC


target=1.0
lambd=0.0
epoch=35
lr=1e-4
for budget in 0.125 0.15 0.175 0.2
do
	python3 -u run.py experiment=imagenet/vit/vit-b-gaudi-finetune +task_name="imagenet-vit-s-gaudi-finetune" datamodule.data_dir=$IMAGENET_DIR $common_args model.mlp_cfg.linear1_cfg.compute_mode='dense' callbacks.init_from_pretrained.budget=$budget callbacks.shrink.target=$target model.mlp_cfg.linear1_cfg.width_learning_rate=$lr model.drop_path_rate=0.1 train.scheduler.t_initial=$epoch callbacks.shrink.lambd=$lambd  
done

