#!/bin/bash


for model in ae vae
do
       for dataset in cifar10 cifar10_nonorm cifar100 cifar100_nonorm fmnist
       do
              for seed in 0 1
              do
                     for decoder_norm in l2
                     do
                            python src/rel2abs/run.py nn=aes train=reconstruction \
                                   nn/module/model=$model \
                                   nn/data/datasets=vision/$dataset \
                                   nn/module/model/decoder_in_normalization=$decoder_norm \
                                   train.seed_index=$seed \
                                   core.tags="[aes,$model,$dataset,$decoder_norm,run$seed]"
                            echo
                     done
              done
       done
done
