# Models to embed, organized by wandb tags:
#  - dataset
#  - model
#  - decoder norm
#  - seed

AES_MODELS = {
    "mnist": {
        "ae": {
            "l2": {
                "run0": "5caubj4e",
                "run1": "pbcrtbpf",
            },
            "none": {
                "run0": "cvt1yw7g",
                "run1": "cvw1ut2g",
            },
        },
        "vae": {
            "l2": {
                "run0": "628rag7x",
                "run1": "rkx1l5s7",
            },
            "none": {
                "run0": "pwneyibe",
                "run1": "s0dx39x5",
            },
        },
    },
    "fmnist": {
        "ae": {
            "l2": {
                "run0": "rl4ceinc",
                "run1": "6pitur4b",
            },
            "none": {
                "run0": "7zdxzdb5",
                "run1": "hjfbjo5l",
            },
        },
        "vae": {
            "l2": {
                "run0": "f2ts7emo",
                "run1": "ssd77kcr",
            },
            "none": {
                "run0": "uydv79dn",
                "run1": "wuqbljm4",
            },
        },
    },
    "cifar10": {
        "ae": {
            "l2": {
                "run0": "9q04eov4",
                "run1": "q0zt4btu",
            },
            "none": {
                "run0": "qa8lxuvu",
                "run1": "rufz7bv3",
            },
        },
        "vae": {
            "l2": {
                "run0": "r8m0vnk2",
                "run1": "j9bgzkpn",
            },
            "none": {
                "run0": "1n6dqoys",
                "run1": "pquhrylp",
            },
        },
    },
    "cifar100": {
        "ae": {
            "l2": {
                "run0": "yluxytug",
                "run1": "vbxdavwa",
            },
            "none": {
                "run0": "cw8ujq4f",
                "run1": "e7r28ao0",
            },
        },
        "vae": {
            "l2": {
                "run0": "3fh676ha",
                "run1": "ngxa1npn",
            },
            "none": {
                "run0": "hi848ivf",
                "run1": "v9i7juxw",
            },
        },
    },
    "cifar10_nonorm": {
        "ae": {
            "l2": {
                "run0": "tbxwg4j1",
                "run1": "bc6ztbo7",
            },
            "none": {
                "run0": "5ehxk41c",
                "run1": "6yqce2jo",
            },
        },
        "vae": {
            "l2": {
                "run0": "gm4qtyxr",
                "run1": "6bi5km75",
            },
            "none": {
                "run0": "s44xbc6m",
                "run1": "l6gkxxu2",
            },
        },
    },
    "cifar100_nonorm": {
        "ae": {
            "l2": {
                "run0": "t12ei05o",
                "run1": "jbn1ah42",
            },
            "none": {
                "run0": "j04vvxu8",
                "run1": "lx43c29s",
            },
        },
        "vae": {
            "l2": {
                "run0": "ot0phkkp",
                "run1": "7nksbwi7",
            },
            "none": {
                "run0": "cz3vdj8h",
                "run1": "r0ei1zcj",
            },
        },
    },
}
