# To create Particular summaries for each network
#

#%% Import libraries
import EvDyNET
import matplotlib.pyplot as plt
from IPython.display import display
import numpy as np 
import pandas as pd 
import time  

#%% Parameters 
# --- Dataset
path_dataset = 'DANYCH/TUDataset/TUD_BZR_MD.dyne'    # 0, 1, '', 'node_labels'
#path_dataset = 'DANYCH/TUDataset/TUD_COX2_MD.dyne'    # 0, 1, '', 'node_labels'
#path_dataset = 'DANYCH/TUDataset/TUD_DHFR_MD.dyne'    # 0, 1, '', 'node_labels'
#path_dataset = 'DANYCH/TUDataset/TUD_ER_MD.dyne'    # 0, 1, '', 'node_labels'

#path_dataset = 'DANYCH/TUDataset/TUD_BZR.dyne'   # 3, 0, 'node_attr', ''
#path_dataset = 'DANYCH/TUDataset/TUD_COX2.dyne'   # 3, 0, 'node_attr', ''
###path_dataset = 'DANYCH/TUDataset/TUD_DHFR.dyne'   # 3, 0, 'node_attr', ''
#path_dataset = 'DANYCH/TUDataset/TUD_PROTEINS.dyne'   # 1, 0, 'node_attr', '' 

#path_dataset = 'DANYCH/TUDataset/TUD_IMDB-BINARY.dyne'   # 0, 0, '', ''
###path_dataset = 'DANYCH/TUDataset/TUD_IMDB-MULTI.dyne'   # 0, 0, '', ''
#path_dataset = 'DANYCH/TUDataset/TUD_MUTAG.dyne'   # 0, 0, '', ''
###path_dataset = 'DANYCH/TUDataset/TUD_NCI1.dyne'   # 0, 0, '', ''

# --- Where to save...
pathSaveOut = 'EXPERIMENT/FEATURES_NETS/' # Only the folder

#%% Open Dataset and Fill-Out Additional Parameters
print('Open Dataset ...')  
DyNet = EvDyNET.Load_Dynamic_Network(path_dataset)   
print('Done!')  
#DyNet.show('last')  

# Period of Dynamic Network  
indexPeriod = np.arange(0, DyNet.number_nets) # Numpy Array with indices of Nets
#indexPeriod = indexPeriod[:30]

#%% ***** OVER THE DYNAMIC NETWORK *****  
# Create Empty Datasets
mat_Avg_Nodes = np.zeros((len(indexPeriod), DyNet.df_nodes[0].shape[1]))
mat_Avg_Edges = np.zeros((len(indexPeriod), DyNet.df_edges[0].shape[1]))

# Foor-Loop Over the Dynamic Network
for ikx, iG in enumerate(indexPeriod): # For all the selected nets  
    # Average on Nodes 
    mat_Avg_Nodes[iG, :] = np.mean(DyNet.df_nodes[iG].to_numpy(), axis=0)
    # Average on Edges 
    mat_Avg_Edges[iG, :] = np.mean(DyNet.df_edges[iG].to_numpy(), axis=0)

# Create Dataframes
df_Avg_Nodes = pd.DataFrame(mat_Avg_Nodes, columns=list(DyNet.df_nodes[0].columns))  
df_Avg_Nodes.index.name = 'Net'
df_Avg_Edges = pd.DataFrame(mat_Avg_Edges, columns=list(DyNet.df_edges[0].columns))
df_Avg_Edges.index.name = 'Net'

# Delete Columns 
df_Avg_Nodes = df_Avg_Nodes.drop(['ID', 'Label', 'Exist'], axis=1)
df_Avg_Edges = df_Avg_Edges.drop(['From', 'To', 'From_Label', 'To_Label'], axis=1)

#%% Save Dataframes
df_Avg_Nodes.to_csv(pathSaveOut+'Avg_Nodes_'+path_dataset.split('/')[-1].split('.')[0]+'.csv')
df_Avg_Edges.to_csv(pathSaveOut+'Avg_Edges_'+path_dataset.split('/')[-1].split('.')[0]+'.csv')


# %%
