import time
import math
import pandas as pd
import numpy as np
from rf import *

dataset_name = 'IMDB-BINARY'
mp_path = 'All_Entropy_UNNormalized/'
feature_path = 'FEATURES_NETS/'
node_features = pd.read_csv(feature_path + 'Avg_Nodes_TUD_' + dataset_name + '.csv').values
edge_features = pd.read_csv(feature_path + 'Avg_Edges_TUD_' + dataset_name + '.csv').values

dim = 'H0' # 'H1'
# ['MP_vectors', 'arrayClass', 'arrayTime', 'arrayParams']
MP = np.load(mp_path + 'Win_Vector_' + dim + '_MP_TUD_IMDB-BINARY_Filt1_50_Katz_Node_and_Power_Ricci_Positive_Edge_Filt2_50.npz', allow_pickle=True)
MP_vectors = MP['MP_vectors'].reshape(-1, 50*50)
MP_y = MP['arrayClass']

# only MP vectorization input
MP_vectors_input = [i for i in MP_vectors] # have to convert to 2D dataset
# MP vectorization + node features
MP_vectors_nodes_input_ = np.concatenate([MP_vectors, node_features], axis=-1)
MP_vectors_nodes_input = [i for i in MP_vectors_nodes_input_]
# MP vectorization + node features + edge features
MP_vectors_nodes_edges_input_ = np.concatenate([MP_vectors, node_features, edge_features], axis=-1)
MP_vectors_nodes_edges_input = [i for i in MP_vectors_nodes_edges_input_]

# y_label
MP_label_input = [int(i) for i in MP_y]

# run rf on MP/node features
run_rf(MP_vectors_input, MP_label_input, n_iterations=10)
print("MP vectors experiment completed")

run_rf(MP_vectors_nodes_input, MP_label_input, n_iterations=10)
print("MP vectors + nodes experiment completed")

run_rf(MP_vectors_nodes_edges_input, MP_label_input, n_iterations=1)
print("MP vectors + nodes + edges experiment completed")







#print(BZR_MP_vectors_H0.shape) # (405, 50, 50)
#print(BZR_MP_y_H0.shape) # (405, )