# MULTIPARAMETER PERSISTENCE 
# To Extract 
# ------------------------------------------------------
# Description of content for the input file
# display(npzData.files) -> ['MPZZGrid', 'arrayTime', 'arrayParams'] 
# npzData['MPZZGrid'][ i, k ], where 
# i-> First Filtration, the lower index means lower filtration-value
# k-> Second Filtration, the lower index means lower filtration-value
# npzData['arrayTime'][0] # Seconds
# npzData['arrayTime'][1] # Minutes
# npzData['arrayTime'][2] # Hours
# npzData['arrayParams'][0] # Dataset file and path
# npzData['arrayParams'][1] # [Feature, Node/edge, 0/1] -> First filtration
# npzData['arrayParams'][2] # [Feature, Node/edge, 0/1] -> Second filtration
# npzData['arrayParams'][3] # Power Filtration in Second filtration? (True/False) 
# npzData['arrayParams'][4] # Max dimension of Holes
# npzData['arrayParams'][5] # [grid_size_filt_1, grid_size_filt_2]
# npzData['arrayParams'][6] # indexPeriod from the Dynamic Network
# ------------------------------------------------------
#

#%% Libraries
import numpy as np 
from IPython.display import display
from gudhi.representations import Silhouette
from gudhi.representations import BettiCurve
from gudhi.representations import Entropy
import matplotlib.pyplot as plt
import time
import ray # For parallel Computing 

# Number of Cores
NCores = 7  

#%% Parameters
nameFileInput = 'EXPERIMENT/MP_2D/MP_TUD_COX2_MD_Filt1_50_nodattr_0_Node_and_Power_edgattr_0_Edge.npz'
#nameFileInput = 'EXPERIMENT/MP_2D/MP_TUD_DHFR_MD_Filt1_50_nodattr_0_Node_and_Power_edgattr_0_Edge.npz'
#nameFileInput = 'EXPERIMENT/MP_2D/MP_TUD_BZR_MD_Filt1_50_Degree_edgattr_0_Node_and_Power_edgattr_0_Edge.npz'
#nameFileInput = 'EXPERIMENT/MP_2D/MP_TUD_IMDB-BINARY_Filt1_50_Katz_Node_and_Power_Ricci_Positive_Edge.npz'
#nameFileInput = 'EXPERIMENT/MP_2D/MP_TUD_MUTAG_Filt1_50_Katz_Node_and_Power_Ricci_Positive_Edge.npz'
#nameFileInput = 'EXPERIMENT/MP_2D/MP_TUD_PROTEINS_Filt1_50_Closeness_Node_and_Power_Betweenness_Edge.npz'


# To choose the dimension of the topological summary; e.g. 0-dimensional, 1-dimensional, 2-dimensional...  
dimHomology = 0  
# Type of Vectorization: [0] Betti Curves, [1] Silhouette, 
# [2] Entropy Summary Function (un-normalized), [3] Entropy Summary function (Normalized)
TypeVectorization = 2  ###   2 
# Resolution for vectorization (e.g. Silhouette )
valResol = 50 #  10 and 50     
# To save Output File  
nameSaveOut = 'EXPERIMENT/VECTOR_MP_2D/Win_Vector_H'+str(dimHomology)+'_'+nameFileInput.split('/')[-1].split('.')[0]+'_Filt2_'+str(valResol)+'.npz'    

#%% Open Dataset and fill-out other parameters
npzData = np.load(nameFileInput, allow_pickle=True)  
#npzData.files
#npzData['MPGrid']
# Total of graphs in the dynamic network
NGraphs = npzData['arrayParams'][6].shape[0]   
dimGrid = npzData['arrayParams'][5] # Dimensions of the 2D-Multi-Grid (First Filtration)  

#%% Compute the functions for the barcode windows 
# (e.g. vectorization via silhouette, landscape, Persistence Images, etc ) 
# https://github.com/GUDHI/TDA-tutorial/blob/master/Tuto-GUDHI-representations.ipynb
# https://gudhi.inria.fr/python/latest/representations.html
# https://github.com/GUDHI/TDA-tutorial/blob/master/Tuto-GUDHI-persistent-entropy.ipynb

# Start acumulating time
start_time_MPZwin = time.time()

# Using parallel
ray.init(num_cpus = NCores) # Specify this system has 4 CPUs

# Function to compute vectorization in a 2D-Grid
@ray.remote # Decorator for Parallel Computing 
def Vectorization_2DGrid(MPGrid, kNet, dimGrid, TypeVectorization, valResol):
    Grid_Vectors = np.zeros((dimGrid, valResol))    
    # The sample range
    auxVec = np.array([])  
    for jCol in range(dimGrid): # Second Filtration
        auxVec = np.concatenate((auxVec, MPGrid[kNet, jCol][:,[1,2]].flatten()))  
    
    sample_domain_fit = [min(auxVec), max(auxVec)] # For the other methods
    sample_domain_open = [min(auxVec), max(auxVec)-0.00001] # Entropy requires this type of domain to work properly
    
    # Second Filtration  
    for jCol in range(dimGrid): 
        if(MPGrid[kNet,jCol].shape[0]>0): # There is at least one-bar  
            # Type of Vectorization: [0] Betti Curves, [1] Silhouette, 
            # [2] Entropy Summary Function (un-normalized), [3] Entropy Summary function (Normalized)
            if(TypeVectorization==0): # [0] Betti Curves
                lsSH = BettiCurve(resolution=valResol, sample_range=sample_domain_fit).fit_transform([  MPGrid[kNet, jCol][MPGrid[kNet, jCol][:,0]==dimHomology, 1:3]  ]) # BCW  
            elif(TypeVectorization==1): # [1] Silhouette
                lsSH = Silhouette(resolution=valResol).fit_transform([  MPGrid[kNet, jCol][MPGrid[kNet, jCol][:,0]==dimHomology, 1:3]  ]) # BCW  
                #lsSH = Silhouette(resolution=valResol, weight=lambda x: np.power(x[1]-x[0],1/10)).fit_transform([mapWin_BC[iRow, jCol][kWin]]) # BCW
            elif(TypeVectorization==2): # [2] Entropy Summary Function (un-normalized) # --- The Good one with normalized=False
                lsSH = Entropy(mode='vector', resolution=valResol, sample_range=sample_domain_open, normalized=False).fit_transform([  MPGrid[kNet, jCol][MPGrid[kNet, jCol][:,0]==dimHomology, 1:3]  ]) # BCW  
            elif(TypeVectorization==3): # [3] Entropy Summary function (Normalized)
                lsSH = Entropy(mode='vector', resolution=valResol, sample_range=sample_domain_open, normalized=True).fit_transform([  MPGrid[kNet, jCol][MPGrid[kNet, jCol][:,0]==dimHomology, 1:3]  ]) # BCW      
            Grid_Vectors[jCol, :] = lsSH[0].copy()  
    # The Final Matrix   
    return(Grid_Vectors)

# -------
print('Building Vectorizations for each PERSISTENT DIAGRAM')
previous_time = time.time()  

MPGrid = npzData['MPGrid'].copy()  

# Generate FUTURES
lsFUT = [] 
###for kWin in range(16): # index for Window
for kNet in range(NGraphs): # index for Window
    lsFUT.append( Vectorization_2DGrid.remote(MPGrid, kNet, dimGrid, TypeVectorization, valResol) )  

# Run the tasks in parallel  
results = ray.get( lsFUT ) 

# Assign Results in the New Matrix: MPZ_vectors = np.zeros((number_windows, dimGrid[0], dimGrid[1], valResol))
MP_vectors = np.array(results)

print("TIME: "+str((time.time() - previous_time))+" Seg ---  "+str((time.time() - previous_time)/60)+" Min ---  "+str((time.time() - previous_time)/(60*60))+" Hr ")
print('Done!')

# Shutdown the parallelization library
ray.shutdown()

#%% To Save the Files
# Add Timing to Compute Vectorization
arrayTimeWin = []  
arrayTimeWin.append(time.time()-start_time_MPZwin) # Seconds  
arrayTimeWin.append((time.time()-start_time_MPZwin)/60) # Minutes  
arrayTimeWin.append((time.time()-start_time_MPZwin)/(60*60)) # Hours  
arrayTimeWin = np.array(arrayTimeWin)  
arrayTime = npzData['arrayTime'].copy()  
arrayTime= np.concatenate(([arrayTime], [arrayTimeWin]), axis=0).copy()
# Each graph's graphs
arrayClass = npzData['arrayClass'].copy()
# Add Parameters  
arrayParams = npzData['arrayParams'].copy()  
if(TypeVectorization==0): # [0] Betti Curves
    arrayParams = np.concatenate((arrayParams, np.array(['Betti Curves'])))
elif(TypeVectorization==1): # [1] Silhouette
    arrayParams = np.concatenate((arrayParams, np.array(['Silhouette'])))
elif(TypeVectorization==2): # [2] Entropy Summary Function (un-normalized) # --- The Good one with normalized=False
    arrayParams = np.concatenate((arrayParams, np.array(['Entropy Summary Function (un-normalized)'])))
elif(TypeVectorization==3): # [3] Entropy Summary function (Normalized)
    arrayParams = np.concatenate((arrayParams, np.array(['Entropy Summary function (Normalized)'])))  
arrayParams = np.concatenate((arrayParams, np.array([valResol])))
arrayParams = np.concatenate((arrayParams, np.array([dimHomology])))  

# To Save all Variables  
np.savez(nameSaveOut, MP_vectors=MP_vectors, arrayClass=arrayClass, arrayTime=arrayTime, arrayParams=arrayParams) 

#%% Load Files to test everything is ok  
# import numpy as np 
# from IPython.display import display  
# import matplotlib.pyplot as plt
# #nameSaveOut = 'EXPERIMENT/VECTOR_MP_2D/Betti/Win_Vector_H0_MP_TUD_COX2_MD_Filt1_50_Degree_edgattr_0_Node_and_Power_edgattr_0_Edge_Filt2_50.npz'
# #nameSaveOut = 'EXPERIMENT/VECTOR_MP_2D/Betti/Win_Vector_H1_MP_TUD_COX2_MD_Filt1_50_Degree_edgattr_0_Node_and_Power_edgattr_0_Edge_Filt2_50.npz'

# #nameSaveOut = 'EXPERIMENT/VECTOR_MP_2D/Entropy_Normalized/Win_Vector_H0_MP_TUD_MUTAG_Filt1_50_Katz_Node_and_Power_Ricci_Positive_Edge_Filt2_50.npz'
# #nameSaveOut = 'EXPERIMENT/VECTOR_MP_2D/Entropy_Normalized/Win_Vector_H1_MP_TUD_MUTAG_Filt1_50_Katz_Node_and_Power_Ricci_Positive_Edge_Filt2_50.npz'

npzfile = np.load(nameSaveOut, allow_pickle=True)  
display(npzfile.files)
display(npzfile['MP_vectors'].shape)
display(npzfile['arrayClass'])  
display(npzfile['arrayTime'])  
display(npzfile['arrayParams'])   

#%% Ploting some examples
# MPVec = npzfile['MP_vectors'].copy() 
# for kNet in range(MPVec.shape[0]): # index for Window
#     print(f'Vectorization: {kNet}')
#     fig = plt.figure(num=None, figsize=(10, 5), dpi=80, facecolor='w', edgecolor='k')  
#     fig.patch.set_facecolor('snow') # white -> https://matplotlib.org/stable/gallery/color/named_colors.html
#     plt.imshow(MPVec[kNet], interpolation='bilinear', cmap="copper_r")
#     plt.colorbar()
#     plt.xlabel("Filtration 2")
#     plt.ylabel("Filtration 1")
#     #plt.title(str(npzData['arrayParams'][6][kNet])+' - index: '+str(kNet))
#     plt.title('index: '+str(kNet))
#     plt.show()
#     #display(MP_vectors[kNet].flatten())  

# %%
