# Data

## Traveling Salesman Problem

### TSP-50 & TSP-100

The evaluation data of TSP-50 and TSP-100 data are taken from [chaitjo/learning-tsp](https://github.com/chaitjo/learning-tsp).

### TSP-500

The evaluation data of TSP-500 are taken from [Spider-scnu/TSP](https://github.com/Spider-scnu/TSP).

The training data of TSP-50, TSP-100, and TSP-500 are generated by the following commands.

## Training data generation
python tsp_gendata.py --mode generate --num_nodes 200 --num_samples 200000 --seed 1997
python tsp_gendata.py --mode solve --solver ortools --num_nodes 100 --num_samples 10000 --seed 1997
python tsp_gendata.py --mode solve --solver concorde --num_nodes 200 --num_samples 200000 --seed 1997 > solve_n200_training.log 2>&1 &
python tsp_gendata.py --mode solve --solver concorde --num_nodes 50 --num_samples 10000 --seed 7991  > solve_n50_test.log 2>&1 &

## Training prefix_difusco
python train_diffusion_new_2gpu_new_tsp50.py 
python train_diffusion_new_2gpu_new_tsp100.py 
python train_diffusion_new_2gpu_new_tsp500_from_tsp100.py 

# Inference
python hybrid_solver_pomo_new_v2_tsp100_se_new.py --config hybrid_eval_config_tsp100_se_pomo.yaml  

python hybrid_solver_pomo_new_v2_tsp200_se_new.py --config hybrid_eval_config_tsp200_se_pomo.yaml  

python hybrid_solver_pomo_new_v2_tsp500_se_new.py --config hybrid_eval_config_tsp500_se_pomo.yaml  
python hybrid_solver_pomo_new_v2_tsp1000_se_new.py --config hybrid_eval_config_tsp1000_se_pomo.yaml  


python hybrid_solver_am_new_v2_tsp50.py --config hybrid_eval_config_tsp50_am.yaml 

python hybrid_solver_am_new_v2_tsp100.py --config hybrid_eval_config_tsp100_am.yaml     > output_evaluationFULL.log 2>&1 &