#!/bin/bash

#=========================================================================================
# Slurm SBATCH Directives
#=========================================================================================
#
#SBATCH --job-name=op_diffusion_train      # 为你的任务起一个具有描述性的名字
#SBATCH --output=op_train_100.out      # 标准输出日志文件 (%j 会被替换为任务ID)
#SBATCH --error=op_train_100.err       # 标准错误日志文件
#SBATCH --partition=gpu
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --gres=gpu:2
#SBATCH --cpus-per-task=12
#SBATCH --mem=64G
#SBATCH --time=48:00:00

#=========================================================================================
# Job Preparation & Execution
#=========================================================================================

# 1. 在日志文件中打印任务信息，方便调试
echo "================================================================================="
echo "Job ID: $SLURM_JOB_ID"
echo "Job Name: $SLURM_JOB_NAME"
echo "Node List: $SLURM_JOB_NODELIST"
echo "Number of Nodes: $SLURM_NNODES"
echo "Tasks per Node: $SLURM_NTASKS_PER_NODE"
echo "GPUs per Node: $SLURM_GPUS_ON_NODE"
echo "Submission Directory: $SLURM_SUBMIT_DIR"
echo "================================================================================="
echo ""



# 3. 执行分布式训练脚本
# 我们使用 torchrun，它会自动读取 Slurm 环境变量 (如 SLURM_PROCID, SLURM_NTASKS)
# 来设置分布式通信 (rank, world_size 等)，无需手动设置 MASTER_ADDR/PORT。
#
# --nproc_per_node 应该与上面 #SBATCH --ntasks-per-node 的值匹配。
# 将 'train_diffusion_new_2gpu_tsp1000_sparse.py' 替换为您的最终脚本名。
# 建议将其重命名为一个更简洁的名字，例如 train_op.py

echo "Starting training script..."

python -m torch.distributed.run --nproc_per_node=2 --standalone \
    train_diffusion_2gpu_op100_sparse.py

echo "================================================================================="
echo "Job finished with exit code $?."
echo "================================================================================="
